<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="mx-auto max-w-7xl px-4 py-8">
        <div class="mb-6">
            <a href="<?php echo e(route('kelas', $classId)); ?>" class="inline-flex items-center text-blue-600 hover:underline">
                <svg xmlns="http://www.w3.org/2000/svg" class="mr-1 h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                Kembali ke Kelas
            </a>
        </div>

        <div class="grid grid-cols-1 gap-8 lg:grid-cols-3">
            <?php if(!$submission && $assignment->duration_minutes): ?>
                <div class="lg:col-span-1">
                    <div class="sticky top-16 space-y-6">
                        <div class="rounded-xl border border-red-200 bg-white p-6 shadow-lg">
                            <h3 class="mb-3 flex items-center gap-2 text-xl font-bold text-red-700">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                Sisa Waktu
                            </h3>
                            <div id="countdown-timer" class="text-center text-4xl font-extrabold text-red-600">
                                --:--:--
                            </div>
                            <p class="mt-2 text-center text-sm text-gray-500">Waktu akan berakhir secara otomatis saat 00:00:00</p>
                        </div>

                        <div class="rounded-xl bg-white p-6 shadow-lg">
                            <h3 class="mb-4 text-xl font-bold text-gray-800">Navigasi Soal</h3>
                            <div id="question-navigator" class="flex flex-wrap gap-2">
                                <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="#question-<?php echo e($question->id); ?>" id="nav-<?php echo e($question->id); ?>" class="flex h-8 w-8 items-center justify-center rounded-lg border border-gray-300 bg-gray-100 text-sm font-semibold text-gray-600 transition duration-150 hover:bg-indigo-100">
                                        <?php echo e($loop->iteration); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="<?php echo e(!$submission && $assignment->duration_minutes ? 'lg:col-span-2' : 'lg:col-span-3'); ?>">
                <div class="overflow-hidden rounded-xl bg-white shadow-lg">
                    <div class="bg-gradient-to-r from-[#20C896] to-[#259D7A] px-6 py-5 text-white">
                        <h1 class="text-3xl font-extrabold"><?php echo e($assignment->title); ?></h1>
                        <p class="mt-2 text-sm opacity-90">
                            Durasi: **<?php echo e($assignment->duration_minutes); ?> menit**
                            <?php if($assignment->due_date): ?>
                                | Batas Akhir: <?php echo e(\Carbon\Carbon::parse($assignment->due_date)->translatedFormat('d F Y, H:i')); ?>

                            <?php endif; ?>
                        </p>
                    </div>

                    <div class="p-6">
                        <?php if($assignment->description): ?>
                            <div class="prose prose-slate mb-6 max-w-none border-b pb-4">
                                <h2 class="text-xl font-semibold text-gray-700">Petunjuk Pengerjaan</h2>
                                <?php echo $assignment->description; ?>

                            </div>
                        <?php endif; ?>

                        <?php if($submission): ?>
                            <div class="mb-6 rounded-lg border border-blue-400 bg-blue-100 p-6 text-center">
                                <h3 class="flex items-center justify-center gap-2 text-xl font-bold text-blue-800">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    Kuis Selesai!
                                </h3>
                                <p class="mt-2 text-gray-600">Anda telah menyelesaikan kuis ini pada <?php echo e(\Carbon\Carbon::parse($submission->created_at)->translatedFormat('d F Y, H:i')); ?>. Silakan tunggu penilaian dari mentor/sistem.</p>
                            </div>
                        <?php else: ?>
                            <form id="quiz-form" method="POST" action="<?php echo e(route('quiz.submit', ['classId' => $classId, 'assignmentId' => $assignment->id])); ?>">
                                <?php echo csrf_field(); ?>
                                <div id="quiz-questions" class="space-y-10">
                                    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div id="question-<?php echo e($question->id); ?>" class="question-item rounded-xl border border-gray-100 bg-gray-50/50 p-6">

                                            
                                            <div class="mb-4 flex items-start gap-3">
                                                <span class="flex h-8 w-8 shrink-0 items-center justify-center rounded-full bg-[#20C896] font-bold text-white">
                                                    <?php echo e($loop->iteration); ?>

                                                </span>
                                                <div class="prose prose-slate max-w-none text-lg font-medium text-gray-800">
                                                    <?php echo $question->question_text; ?>

                                                </div>
                                            </div>

                                            <div class="space-y-3">
                                                <?php
                                                    $options = [];
                                                    if ($question->option_a) {
                                                        $options[] = ['key' => 'A', 'text' => $question->option_a];
                                                    }
                                                    if ($question->option_b) {
                                                        $options[] = ['key' => 'B', 'text' => $question->option_b];
                                                    }
                                                    if ($question->option_c) {
                                                        $options[] = ['key' => 'C', 'text' => $question->option_c];
                                                    }
                                                    if ($question->option_d) {
                                                        $options[] = ['key' => 'D', 'text' => $question->option_d];
                                                    }
                                                    shuffle($options);
                                                ?>

                                                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <label class="flex cursor-pointer items-start gap-4 rounded-lg border border-gray-200 bg-white p-4 transition duration-150 hover:bg-indigo-50">
                                                        <input type="radio" name="question_<?php echo e($question->id); ?>" value="<?php echo e($opt['key']); ?>" class="peer mt-1 h-5 w-5 text-indigo-600" required data-question-id="<?php echo e($question->id); ?>">
                                                        <span class="prose font-medium text-gray-700">
                                                            <?php echo $opt['text']; ?>

                                                        </span>
                                                    </label>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="mt-10 flex justify-end">
                                    <button type="submit" id="submit-button" class="rounded-xl bg-gradient-to-r from-[#20C896] to-[#259D7A] px-8 py-4 text-lg font-bold text-white shadow-xl transition duration-300 hover:opacity-90">
                                        Kirim Jawaban dan Selesaikan Kuis
                                    </button>
                                </div>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <?php if(!$submission && $assignment->duration_minutes): ?>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const durationMinutes = <?php echo e($assignment->duration_minutes); ?>;
                const timerElement = document.getElementById('countdown-timer');
                const form = document.getElementById('quiz-form');
                const submitButton = document.getElementById('submit-button');
                const questionNavigator = document.getElementById('question-navigator');

                // Waktu Akhir: Kita asumsikan kuis dimulai saat halaman dimuat
                // Ini akan memerlukan penyesuaian di sisi backend jika Anda ingin
                // waktu tetap berjalan saat user menutup/membuka halaman.
                // Untuk demo ini, kita menggunakan Local Storage.

                const startKey = 'quiz_start_time_<?php echo e($assignment->id); ?>';
                const endKey = 'quiz_end_time_<?php echo e($assignment->id); ?>';

                let endTime;

                // Cek apakah ada waktu mulai tersimpan
                let startTime = localStorage.getItem(startKey);

                if (!startTime) {
                    // Jika belum ada, set waktu mulai sekarang
                    startTime = Date.now();
                    localStorage.setItem(startKey, startTime);

                    // Hitung waktu akhir
                    endTime = startTime + (durationMinutes * 60 * 1000);
                    localStorage.setItem(endKey, endTime);
                } else {
                    // Jika ada, ambil waktu akhir yang tersimpan
                    endTime = parseInt(localStorage.getItem(endKey));
                }

                function formatTime(ms) {
                    const totalSeconds = Math.floor(ms / 1000);
                    const hours = Math.floor(totalSeconds / 3600);
                    const minutes = Math.floor((totalSeconds % 3600) / 60);
                    const seconds = totalSeconds % 60;

                    const pad = (num) => String(num).padStart(2, '0');

                    return `${pad(hours)}:${pad(minutes)}:${pad(seconds)}`;
                }

                function updateTimer() {
                    const now = Date.now();
                    const remainingTime = endTime - now;

                    if (remainingTime <= 0) {
                        // Waktu Habis!
                        clearInterval(timerInterval);
                        timerElement.textContent = "00:00:00";
                        submitButton.disabled = true;
                        submitButton.textContent = 'Waktu Habis. Mengirim Jawaban...';

                        // Otomatis submit form
                        form.submit();

                        // Clear storage setelah submit
                        localStorage.removeItem(startKey);
                        localStorage.removeItem(endKey);

                        return;
                    }

                    timerElement.textContent = formatTime(remainingTime);
                }

                // --- Navigasi Soal dan Penanda Jawaban ---
                const radioButtons = form.querySelectorAll('input[type="radio"]');

                radioButtons.forEach(radio => {
                    radio.addEventListener('change', function() {
                        const questionId = this.dataset.questionId;
                        const navItem = document.getElementById(`nav-${questionId}`);

                        // Tandai di navigasi
                        if (navItem) {
                            navItem.classList.remove('bg-gray-100', 'border-gray-300', 'text-gray-600');
                            navItem.classList.add('bg-indigo-600', 'border-indigo-600', 'text-white');
                        }
                    });
                });

                // Mulai hitungan mundur setiap 1 detik
                const timerInterval = setInterval(updateTimer, 1000);
                updateTimer(); // Panggil sekali untuk menampilkan waktu segera

                // Cleanup storage saat form disubmit normal
                form.addEventListener('submit', function() {
                    localStorage.removeItem(startKey);
                    localStorage.removeItem(endKey);
                });
            });
        </script>
    <?php endif; ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\tugas\capstone-project\web_kursus2\resources\views/student/quiz/quiz.blade.php ENDPATH**/ ?>