<?php $__env->startSection('manage-content'); ?>
    <div class="max-w-4xl">
        <div class="mb-6 flex items-center gap-4">
            <a href="<?php echo e(route('mentor.kelolakursusmateri', $course->id)); ?>" class="flex h-10 w-10 items-center justify-center rounded-full border border-slate-200 bg-white text-slate-600 hover:bg-slate-50">
                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path d="M15 19l-7-7 7-7" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </a>
            <div>
                <h2 class="text-xl font-bold text-slate-800"><?php echo e(isset($material) ? 'Edit Materi' : 'Tambah Materi Baru'); ?></h2>
                <p class="text-xs text-slate-500">Isi materi pembelajaran dengan lengkap dan detail.</p>
            </div>
        </div>

        <form action="<?php echo e(isset($material) && $material->id ? route('mentor.updatemateri', [$course->id, $material->id]) : route('mentor.tambahmateri', $course->id)); ?>" method="POST" enctype="multipart/form-data" class="space-y-8 rounded-[2rem] border border-slate-200 bg-white p-8">
            <?php echo csrf_field(); ?>
            <?php if(isset($material)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>

            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
                <div>
                    <label class="mb-2 block text-[11px] font-black uppercase tracking-widest text-slate-400">Judul Materi</label>
                    <input type="text" name="name" value="<?php echo e(old('name', $material->name ?? '')); ?>" required class="w-full rounded-xl border-slate-200 bg-slate-50 focus:ring-emerald-500" placeholder="Contoh: Dasar-dasar Routing">
                </div>
                <div>
                    <label class="mb-2 block text-[11px] font-black uppercase tracking-widest text-slate-400">ID Video YouTube</label>
                    <input type="text" name="link_video" value="<?php echo e(old('link_video', $material->link_video ?? '')); ?>" class="w-full rounded-xl border-slate-200 bg-slate-50 focus:ring-emerald-500" placeholder="ID-nya saja, misal: dQw4w9WgXcQ">
                </div>
            </div>

            <div>
                <label class="mb-2 block text-[11px] font-black uppercase tracking-widest text-slate-400">Konten Pembelajaran</label>
                <input id="content" type="hidden" name="content" value="<?php echo e(old('content', $material->content ?? '')); ?>">
                <trix-editor input="content" class="trix-content prose min-h-[400px] max-w-none rounded-xl border-slate-200 bg-slate-50 p-4 focus:ring-emerald-500"></trix-editor>
            </div>

            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
                <div class="rounded-2xl border border-slate-100 bg-slate-50/50 p-4">
                    <label class="mb-2 block text-[11px] font-black uppercase text-slate-400">File PDF (Materi)</label>
                    <input type="file" name="pdf" class="text-xs">
                    <?php if(isset($material) && $material->pdf): ?>
                        <p class="mt-2 text-[10px] text-emerald-600">✓ PDF sudah terupload</p>
                    <?php endif; ?>
                </div>
                <div class="rounded-2xl border border-slate-100 bg-slate-50/50 p-4">
                    <label class="mb-2 block text-[11px] font-black uppercase text-slate-400">Gambar Pendukung</label>
                    <input type="file" name="image" class="text-xs">
                </div>
            </div>

            <div x-data="{ needAttend: <?php echo e(isset($material) && $material->is_attendance_required ? 'true' : 'false'); ?> }" class="rounded-3xl border border-emerald-100 bg-emerald-50/30 p-6">
                <div class="mb-4 flex items-center justify-between">
                    <h4 class="text-sm font-bold text-emerald-900">Pengaturan Absensi Otomatis</h4>
                    <input type="checkbox" name="is_attendance_required" x-model="needAttend" class="h-5 w-5 rounded-md text-emerald-600">
                </div>
                <div x-show="needAttend" x-transition class="grid grid-cols-2 gap-6">
                    <div>
                        <label class="mb-1 block text-[10px] font-bold uppercase text-emerald-600">Waktu Mulai</label>
                        <input type="datetime-local" name="attendance_start" value="<?php echo e(old('attendance_start', isset($material) ? \Carbon\Carbon::parse($material->attendance_start)->format('Y-m-d\TH:i') : '')); ?>" class="w-full rounded-xl border-emerald-200">
                    </div>
                    <div>
                        <label class="mb-1 block text-[10px] font-bold uppercase text-emerald-600">Waktu Berakhir</label>
                        <input type="datetime-local" name="attendance_end" value="<?php echo e(old('attendance_end', isset($material) ? \Carbon\Carbon::parse($material->attendance_end)->format('Y-m-d\TH:i') : '')); ?>" class="w-full rounded-xl border-emerald-200">
                    </div>
                </div>
            </div>

            <div class="flex justify-end pt-4">
                <button type="submit" class="rounded-2xl bg-slate-900 px-12 py-4 text-sm font-black text-white shadow-xl transition-all hover:bg-black active:scale-95">
                    <?php echo e(isset($material) ? 'Simpan Perubahan' : 'Terbitkan Materi'); ?>

                </button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php /**PATH D:\tugas\capstone-project\web_kursus2\resources\views/mentor/materi/form.blade.php ENDPATH**/ ?>