
<?php if($paginator->hasPages()): ?>
    <nav role="navigation" aria-label="<?php echo e(__('Pagination Navigation')); ?>" class="flex items-center justify-center">
        <div class="flex items-center gap-2">
            
            <?php if($paginator->onFirstPage()): ?>
                <span class="relative inline-flex cursor-default items-center rounded-xl border border-gray-200 bg-white px-3 py-2 text-sm font-medium text-gray-300">
                    <?php echo __('&laquo; Sebelum'); ?>

                </span>
            <?php else: ?>
                <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" class="relative inline-flex items-center rounded-xl border border-gray-200 bg-white px-3 py-2 text-sm font-medium text-gray-500 transition hover:border-[#20C896] hover:text-[#20C896]">
                    <?php echo __('&laquo; Sebelum'); ?>

                </a>
            <?php endif; ?>

            
            <div class="flex gap-1">
                <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(is_string($element)): ?>
                        <span class="cursor-default px-4 py-2 italic text-gray-400"><?php echo e($element); ?></span>
                    <?php endif; ?>

                    <?php if(is_array($element)): ?>
                        <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($page == $paginator->currentPage()): ?>
                                <span aria-current="page">
                                    <span class="relative inline-flex cursor-default items-center rounded-xl border border-[#20C896] bg-[#20C896] px-4 py-2 text-sm font-bold text-white"><?php echo e($page); ?></span>
                                </span>
                            <?php else: ?>
                                <a href="<?php echo e($url); ?>" class="relative inline-flex items-center rounded-xl border border-gray-200 bg-white px-4 py-2 text-sm font-medium text-gray-700 transition hover:border-[#20C896] hover:bg-green-50 hover:text-[#20C896]" aria-label="<?php echo e(__('Go to page :page', ['page' => $page])); ?>">
                                    <?php echo e($page); ?>

                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            
            <?php if($paginator->hasMorePages()): ?>
                <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" class="relative inline-flex items-center rounded-xl border border-gray-200 bg-white px-3 py-2 text-sm font-medium text-gray-500 transition hover:border-[#20C896] hover:text-[#20C896]">
                    <?php echo __('Lanjut &raquo;'); ?>

                </a>
            <?php else: ?>
                <span class="relative inline-flex cursor-default items-center rounded-xl border border-gray-200 bg-white px-3 py-2 text-sm font-medium text-gray-300">
                    <?php echo __('Lanjut &raquo;'); ?>

                </span>
            <?php endif; ?>
        </div>
    </nav>
<?php endif; ?>
<?php /**PATH D:\tugas\capstone-project\web_kursus2\resources\views/vendor/pagination/tailwind.blade.php ENDPATH**/ ?>