<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('essay_assignments', function (Blueprint $table) {
            $table
                ->foreignId('material_id')
                ->nullable()
                ->constrained('materials')
                ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('essay_assignments', function (Blueprint $table) {
            $table->dropForeign(['material_id']);
            $table->dropColumn('material_id');
        });
    }
};
