<?php

namespace App\Http\Middleware;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;
use Closure;

class MentorMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Cek apakah sudah login DAN role-nya tepat 'mentor'
        if (!Auth::check() || Auth::user()->role !== 'mentor') {
            return redirect('/dashboard')->with('error', 'Akses khusus Mentor.');
        }

        return $next($request);
    }
}
